/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.EnemyControl;
import control.MenuControl;
import control.SoundControl;
import data.ColorArrangement;
import data.Constants;
import java.io.IOException;
import model.PlayerModel;
import view.BackgroundDrawer;
import view.Fonts;
import view.ScoreDrawer;
import view.StaticDrawer;

public class GameControl {
    private SoundControl soundController = new SoundControl(Constants.SONG_ABSOLUTE_PATH);
    private BackgroundDrawer b = new BackgroundDrawer();
    private EnemyControl e;
    private ScoreDrawer scoreDraw;
    private ScoreDrawer multiplierDraw;
    private int desatTime;
    private PlayerModel p;
    private ColorArrangement colorArrangement;
    private float saturation;
    private boolean beginSong;
    private boolean endSong;

    public GameControl(int iMaxNumEnemies, PlayerModel p) throws IOException {
        this.e = new EnemyControl(iMaxNumEnemies, this);
        this.scoreDraw = new ScoreDrawer();
        this.multiplierDraw = new ScoreDrawer();
        this.colorArrangement = new ColorArrangement();
        this.p = p;
        this.scoreDraw.setPos(Constants.VIEW_WIDTH - 100);
        this.multiplierDraw.setPos(50);
        this.saturation = 0.0f;
        this.desatTime = 0;
        Constants.SCORE = 0;
        this.beginSong = false;
        this.endSong = false;
    }

    public void update() {
        if (!this.beginSong) {
            this.soundController.start();
            this.beginSong = true;
        }
        if (!this.endSong && this.soundController.isEndOfSong()) {
            this.soundController.stop();
            this.endSong = true;
        }
        this.e.move(PlayerModel.x, PlayerModel.y);
        if (Constants.enemyVisualizer) {
            int i = 0;
            while (i < this.e.enemies.size()) {
                this.e.enemies.get((int)i).visRadius = this.soundController.getFftLog().getAvg(this.e.enemies.get(i).getBandNum());
                StaticDrawer.drawEnemyVisualizer(this.e.enemies.get(i), this);
                ++i;
            }
        }
        this.b.move(this.e.getXVel(), this.e.getYVel());
        this.b.draw();
        if (this.e.isEnemyMoving()) {
            if (!this.endSong) {
                this.soundController.resumeSong();
            }
            ++this.desatTime;
        } else if (!this.endSong) {
            this.soundController.pauseSong();
        }
        if (this.soundController.isPlaying()) {
            this.soundController.update(this.e);
        }
        this.p.changeSize(this.soundController.getBassBeat());
        this.p.digest();
        this.e.enemyDeletion();
        float satChange = this.e.checkCollisions(this.p);
        this.saturation += satChange;
        if (Constants.SCORE < 25) {
            this.saturation = 0.0f;
        }
        if (this.saturation > 1.0f) {
            this.saturation = 1.0f;
        } else {
            Constants.MULTIPLIER = (double)this.saturation > 0.85 ? 8 : ((double)this.saturation > 0.55 ? 4 : ((double)this.saturation > 0.25 ? 2 : 1));
        }
        if (this.saturation < 0.0f) {
            this.saturation = 0.0f;
        }
        this.colorArrangement.update(this.p.getBand(), this.saturation, this.soundController.getSongLength(), this.soundController.getPosition(), this.p.isHungry());
        if (this.desatTime >= Constants.DESAT_TIME) {
            this.desatTime = 0;
            this.saturation = (float)((double)this.saturation - 0.01);
        }
        if (Constants.SHOW_VISUALIZER) {
            this.soundController.visualizer();
        }
        if (Constants.drawHalo) {
            StaticDrawer.drawHueHalo(this.p, this);
        }
        if (!this.endSong && Constants.drawVisualizer) {
            StaticDrawer.playerVisualizer(this.p, this.soundController, this.e, this);
        }
        this.p.draw(this.saturation);
        this.e.draw(this.saturation);
        if (Constants.highlightEdible) {
            this.e.isEdible(this.p);
        }
        if (Constants.bDrawProgressBar) {
            StaticDrawer.drawProgressBar(this.soundController.getSongLength(), this.soundController.getPosition(), this);
        }
        Fonts.drawText(60.0f, 30.0f, 1.0, "x" + Integer.toString(Constants.MULTIPLIER), true);
        Fonts.drawText(Constants.VIEW_WIDTH - 80, 30.0f, 1.0, Integer.toString(Constants.SCORE), true);
        Constants.tutorial = Constants.SONG_TO_USE.equals(Constants.TUTORIAL_NAME);
        if (Constants.tutorial) {
            String tutorial;
            if (this.soundController.getPosition() > 0L && this.soundController.getPosition() < 3000L) {
                tutorial = "Remember to keep moving!";
                Fonts.drawText((float)(Constants.VIEW_WIDTH / 2) + MenuControl.offsetX, (float)(Constants.VIEW_HEIGHT * 500 / 800) + MenuControl.offsetY, 0.5, tutorial, true);
            }
            if (this.soundController.getPosition() > 4500L && this.soundController.getPosition() < 8000L) {
                tutorial = "Eat dots of like Color";
                Fonts.drawText((float)(Constants.VIEW_WIDTH / 2) + MenuControl.offsetX, (float)(Constants.VIEW_HEIGHT * 300 / 800) + MenuControl.offsetY, 0.5, tutorial, true);
            }
            if (this.soundController.getPosition() > 10000L && this.soundController.getPosition() < 17000L) {
                tutorial = "multiplier";
                Fonts.drawText(Fonts.getWidth(tutorial, 0.5) / 2.0f + 10.0f + MenuControl.offsetX, 75.0f + MenuControl.offsetY, 0.5, tutorial, true);
                tutorial = "score";
                Fonts.drawText((float)(Constants.VIEW_WIDTH - 80) + MenuControl.offsetX, 75.0f + MenuControl.offsetY, 0.5, tutorial, true);
                tutorial = "progress bar";
                Fonts.drawText(Fonts.getWidth(tutorial, 0.5) / 2.0f + 10.0f + MenuControl.offsetX, (float)Constants.VIEW_HEIGHT - Fonts.getHeight(tutorial, 0.5) + MenuControl.offsetY, 0.5, tutorial, true);
            }
            if (this.soundController.getPosition() > 25000L && this.soundController.getPosition() < 32000L) {
                tutorial = "Larger, more similar dots equal more points and color";
                Fonts.drawText(Fonts.getWidth(tutorial, 0.5) / 2.0f + 10.0f + MenuControl.offsetX, (float)(Constants.VIEW_HEIGHT * 500 / 800) + MenuControl.offsetY, 0.5, tutorial, true);
            }
            if (this.soundController.getPosition() > 42000L && this.soundController.getPosition() < 49000L) {
                tutorial = "They also raise your combo multiplier (look up!)";
                Fonts.drawText(Fonts.getWidth(tutorial, 0.5) / 2.0f + 10.0f + MenuControl.offsetX, (float)(Constants.VIEW_HEIGHT * 100 / 800) + MenuControl.offsetY, 0.5, tutorial, true);
            }
            if (this.soundController.getPosition() > 55000L && this.soundController.getPosition() < 62000L) {
                tutorial = "Want to reverse your current color? Try holding the spacebar";
                Fonts.drawText((float)(Constants.VIEW_WIDTH / 2) + MenuControl.offsetX, (float)(Constants.VIEW_HEIGHT * 500 / 800) + MenuControl.offsetY, 0.5, tutorial, true);
            }
            if (this.soundController.getPosition() > 67000L && this.soundController.getPosition() < 73000L) {
                tutorial = "Hitting unlike colors will lower your combo and gray the world";
                Fonts.drawText((float)(Constants.VIEW_WIDTH - 10) - (Fonts.getWidth(tutorial, 0.5) / 2.0f + 10.0f) + MenuControl.offsetX, (float)(Constants.VIEW_HEIGHT * 500 / 800) + MenuControl.offsetY, 0.5, tutorial, true);
            }
            if (this.soundController.getPosition() > 83000L && this.soundController.getPosition() < 89000L) {
                tutorial = "The song and game pause if you stop moving. Try it!";
                Fonts.drawText((float)(Constants.VIEW_WIDTH / 2) + MenuControl.offsetX, (float)(Constants.VIEW_HEIGHT * 500 / 800) + MenuControl.offsetY, 0.5, tutorial, true);
            }
            if (this.soundController.getPosition() > 100000L && this.soundController.getPosition() < 106000L) {
                tutorial = "Keep moving until the song ends!";
                Fonts.drawText((float)(Constants.VIEW_WIDTH / 2) + MenuControl.offsetX, (float)(Constants.VIEW_HEIGHT * 500 / 800) + MenuControl.offsetY, 0.5, tutorial, true);
            }
            if (this.soundController.getPosition() > 127000L && this.soundController.getPosition() < 133000L) {
                tutorial = "When the song ends, keep moving or eating until there are no orbs on screen";
                Fonts.drawText((float)(Constants.VIEW_WIDTH / 2) + MenuControl.offsetX, (float)(Constants.VIEW_HEIGHT * 500 / 800) + MenuControl.offsetY, 0.5, tutorial, true);
            }
        }
        if (this.endSong && this.e.allEnemiesDead()) {
            Constants.currentGameState = 3;
        }
    }

    public void endGame() {
        if (this.soundController != null) {
            this.soundController.stop();
        }
        this.soundController = null;
        this.b = null;
        this.e = null;
        this.scoreDraw = null;
        this.multiplierDraw = null;
        Constants.currentGameState = 0;
    }

    public ColorArrangement getColorArrangement() {
        return this.colorArrangement;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public SoundControl getSoundController() {
        return this.soundController;
    }

    public void reversedPlayer() {
        this.p.reversedBand();
    }

    public void originalPlayer() {
        this.p.originalBand();
    }

    public void killSoundController() {
        this.soundController = null;
    }
}

